* STOS Maestro Sample Playing & Record Routines *

* These routines act as a library for machine language programmers 
* New Dimensions hereby states that the following routines, labels
* and data tables can be freely modified, copied to other source codes
* and used in a software program whether it is a commercial program or not,
* The routines and or data tables may not be used in another sampling
* package without the written consent of New Dimensions.

* (C) New Dimensions / Mandarin Software 1989

* Program Written by Jon Wheatman

* Written using Hisoft's DEVPAC 2 Assembler Package.


* This source code cannot be assembled and executed without additional
* codeing, it is intended to be used as a library for a programmer
* wishing to play samples within a program, the programmer must take
* the desired routines and include them with the main source code of
* the program.

* Most routines require supervisor mode as follows 

* move.l #0,-(sp)
* move.w #32,-(sp)
* trap #1
* addq.l #6,sp
* move.l d0,save_sp

* to go back to user mode do this

* move.l save_sp,-(sp)
* move.w #32,-(sp)
* trap #1
* addq.l #6,sp


* The Initialising Routine *

* Routine to Initialise PSG sound chip before playing a sample *

* No parameters required, simply JSR INIT


init:	pea snd_init		* Push address of init data
	move.w #32,-(sp)	* DO_SOUND function
	trap #14		* X-BIOS
	addq.l #6,sp		* Stack reset
	rts			* Return 

* Sample play routine, includes code for forward,back,loop,sweep
* Also can be used with samples that include their sample rate,
* if no sample rate is found within the sample then the current
* sample rate is used.

* ON ENTRY:
*            A0.L = START ADDRESS OF PLAY
*            A1.L = LENGTH IN BYTES TO PLAY
*          TYPE.W = 1 - FORWARD PLAY
*                 = 2 - BACKWARD PLAY
*                 = 3 - FORWARD LOOP
*                 = 4 - BACKWARD LOOP
*                 = 5 - SWEEP PLAY
*       AUTO_ON.W = 0 - SAMPLE SPEED MANUAL ( USES CURRENT RATE )
*                 = 1 - SAMPLE SPEED AUTO ( SEARCHES FOR RATE STORED )

*         SPEED.B = 5-32 SAMPLE RATE ( IGNORED IF AUTO_ON = 1 )


* I.E,
* 
* 	LEA SAMSTART,A0		; START ADDRESS
*       LEA SAMLENGTH,A1	; LENGTH TO PLAY
*	MOVE.W #1,TYPE		; NORMAL FORWARD PLAY
*       MOVE.W #1,AUTO_ON	; AUTO SPEED SEARCH
*	JSR PLAYSAM		; PLAY THE SAMPLE

* THE ABOVE CODE COULD ONLY BE USED WITH FILES SAVED USING STOS MAESTRO
* AS AUTO_ON IS SET TO 1, THIS TELLS THE PLAY ROUTINE TO SEARCH FOR
* THE SAMPLE RATE WHICH IS FOUND AFTER A THREE BYTE CODE SAVED WITH
* EVERY STOS MAESTRO FILE, IF THE CODE IS NOT FOUND ( A REPLAY OR PRO-SOUND 
* FILE IS TO BE PLAYED ) THEN THE CURRENT SAMPLE RATE IS USED.


PLAYSAM:

	MOVE.W SR,D7 		; SAVE STATUS
	MOVE.W #$2700,SR	; KILL INTERRUPTS
	MOVE.L A0,STARTADDR	; START ADDRESS STORE
	MOVE.L A1,LENGTH	; LENGTH STORE
	MOVE.L A0,STARTADDR2	; BACKUP
	MOVE.L A1,LENGTH2	; BACKUP

	CLR.B $FFFA19		; STOP TIMER A
	MOVE.B #1,$FFFA19	; START TIMER A
	CMPI.W #1,AUTO_ON	; AUTO MODE ?
	BNE.S NOTON		; NO, DONT SEARCH
	CMPI.B #'J',(A0)	; CHECK CODE DIGIT 1
	BNE.S NOTON		; NOT FOUND USE SET RATE 
	CMPI.B #'O',1(A0)	; CHECK DIGIT 2
	BNE.S NOTON		; NOT FOUND
	CMPI.B #'N',2(A0)	; CHECK DIGIT 3
	BNE.S NOTON		; NOT FOUND
	MOVE.B 3(A0),D3		; 4TH BYTE IS THE RATE
	ANDI.W #$FF,D3		; ISOLATE WORD
	LEA HERTZ,A0		; START OF RATE CONVERSION TABLE
	MOVE.B 0(A0,D3.W),D3	; GET TIMER A DATA FOR SAMRATE
	ADDI.B #19,D3		; ADD 19 TIMER TICKS
	MOVE.B D3,$FFFA1F	; STORE TIMER A DATA
	BRA.S SKIPNXT		; SKIP NEXT BIT

NOTON: 	
	MOVE.B SPEED,d3		; SPEED IN D3
	ADDI.B #19,d3		; ADD 19 TICKS
	MOVE.B D3,$FFFA1F	; STORE THE DATA
SKIPNXT:ORI.B #$20,$FFFA13	; TIMER A MASK 
	ORI.B #$20,$FFFA07	; TIMER A ENABLE
	BCLR.B #3,$FFFA17	; VECTOR
	CMPI.W #1,TYPE		; TYPE 1 FORWARD 
	BEQ.S TYPE1		; 
	CMPI.W #2,TYPE		; TYPE 2 BACKWARD	
	BEQ.S TYPE2		;
	CMPI.W #3,TYPE 		; TYPE 3 FORWARD LOOP
	BEQ.S TYPE3		; 
	CMPI.W #4,TYPE		; TYPE 4 BACKWARD LOOP
	BEQ.S TYPE4		; 
	CMPI.W #5,TYPE		; TYPE 5 SWEEP
	BEQ.S TYPE5		; 
TYPE1:	MOVE.L #PLAYIRQ1,$134	; INTERRUPT ADDRESS 1
	MOVE.W D7,SR		; STATUS BACK AGAIN
	RTS			; RETURN TO CALL
TYPE2:	MOVE.L #PLAYIRQ2,$134	; INTERRUPT ADDRESS 2
	MOVE.L LENGTH,D0	; LENGTH
	ADD.L D0,STARTADDR	; START ADDR
	ADD.L D0,STARTADDR2	; BACKUP
	MOVE.W D7,SR		; STATUS BACK
	RTS			; RET
TYPE3:	MOVE.L #PLAYIRQ3,$134	; INTERRUPT ADDRESS 3
	MOVE.W D7,SR		; STATUS BACK
	RTS			; RET
TYPE4:	MOVE.L #PLAYIRQ4,$134	; INTERRUPT ADDRESS 4
	MOVE.L LENGTH,D0	; LENGTH
	ADD.L D0,STARTADDR	; START ADDRESS
	ADD.L D0,STARTADDR2	; BACKUP
	MOVE.W D7,SR		; STATUS
	RTS			; RET
TYPE5:	MOVE.L #PLAYIRQ5,$134	; INTERRUPT ADDRESS 5
	MOVE.W D7,SR		; STATUS BACK
	RTS			; RET
OUTOFIT:
	ADDQ.L #1,STARTADDR	; START ADDRESS + 1
	BCLR #5,$FFFA07		; CLEAR INTERRUPT
	MOVEM.L (SP)+,D7/A3	; STACK BACK
	RTE			; INTERRUPT RETURN

* FORWARD NORMAL PLAY ROUTINE *

PLAYIRQ1:
	MOVEM.L D7/A3,-(SP)
	MOVEA.L STARTADDR,A3
	MOVE.B (A3),D7
	SUBQ.L #1,LENGTH
	BEQ.S OUTOFIT
	ADDQ.L #1,STARTADDR
	ANDI.W #$FF,D7
	LEA VOLDAT2,A3
	LSL.W #4,D7
	MOVE.L 0(A3,D7.W),PSG
	MOVE.L 4(A3,D7.W),PSG
	MOVE.L 8(A3,D7.W),PSG
	MOVEM.L (SP)+,D7/A3
	RTE

* BACKWARD NORMAL PLAY ROUTINE *

PLAYIRQ2:
	MOVEM.L D7/A3,-(SP)
	MOVEA.L STARTADDR,A3
	MOVE.B (A3),D7
	SUBQ.L #1,LENGTH
	BMI OUTOFIT
	SUBQ.L #1,STARTADDR
	LEA VOLDAT2,A3
	ANDI.W #$FF,D7
	LSL.W #4,D7
	MOVE.L 0(A3,D7.W),PSG
	MOVE.L 4(A3,D7.W),PSG
	MOVE.L 8(A3,D7.W),PSG
	MOVEM.L (SP)+,D7/A3
	RTE

* FORWARD LOOP PLAY ROUTINE *

PLAYIRQ3:
	MOVEM.L D7/A3,-(SP)
	MOVEA.L STARTADDR,A3
	MOVE.B (A3),D7
	SUBQ.L #1,LENGTH
	BMI.S OUTOFIT2
	ADDQ.L #1,STARTADDR
INTOIT2:ANDI.W #$FF,D7
	LEA VOLDAT2,A3
	LSL.W #4,D7
	MOVE.L 0(A3,D7.W),PSG
	MOVE.L 4(A3,D7.W),PSG
	MOVE.L 8(A3,D7.W),PSG
	MOVEM.L (SP)+,D7/A3
	RTE
OUTOFIT2:
	ADDQ.L #1,STARTADDR
	MOVE.L LENGTH2,LENGTH
	MOVE.L STARTADDR2,STARTADDR
	BRA INTOIT2

* BACKWARD LOOP PLAY ROUTINE *

PLAYIRQ4:
	MOVEM.L D7/A3,-(SP)
	MOVEA.L STARTADDR,A3
	MOVE.B (A3),D7
	SUBQ.L #1,LENGTH
	BMI.S OUTOFIT3
	SUBQ.L #1,STARTADDR
INTOIT3:ANDI.W #$FF,D7
	LEA VOLDAT2,A3
	LSL.W #4,D7
	MOVE.L 0(A3,D7.W),PSG
	MOVE.L 4(A3,D7.W),PSG
	MOVE.L 8(A3,D7.W),PSG
	MOVEM.L (SP)+,D7/A3
	RTE
OUTOFIT3:
	ADDQ.L #1,STARTADDR
	MOVE.L LENGTH2,LENGTH
	MOVE.L STARTADDR2,STARTADDR
	BRA INTOIT3


* SWEEP PLAY ROUTINE *

PLAYIRQ5:
	MOVEM.L D7/A3,-(SP)
	MOVEA.L STARTADDR,A3
	moveq.w #7,d7
	MOVE.B (A3),D7
	SUBQ.L #1,LENGTH
	BMI.S OUTOFIT4
	ADDQ.L #1,STARTADDR
INTOIT4:
	LEA VOLDAT2,A3
	LSL.W #4,D7
	MOVE.L 0(A3,D7.W),PSG
	MOVE.L 4(A3,D7.W),PSG
	MOVE.L 8(A3,D7.W),PSG
	MOVEM.L (SP)+,D7/A3
	RTE
OUTOFIT4:
	MOVE.L LENGTH2,LENGTH
	MOVE.L #PLAYIRQ6,$134
	BRA INTOIT4

PLAYIRQ6:
	MOVEM.L D7/A3,-(SP)
	MOVEA.L STARTADDR,A3
	moveq.w #7,d7
	MOVE.B (A3),D7
	SUBQ.L #1,LENGTH
	BMI.S OUTOFIT5
	SUBQ.L #1,STARTADDR
INTOIT5:
	LEA VOLDAT2,A3
	LSL.W #4,D7
	MOVE.L 0(A3,D7.W),PSG
	MOVE.L 4(A3,D7.W),PSG
	MOVE.L 8(A3,D7.W),PSG
	MOVEM.L (SP)+,D7/A3
	RTE
OUTOFIT5:
	MOVE.L LENGTH2,LENGTH
	MOVE.L #PLAYIRQ5,$134
	BRA INTOIT5

* STOP SAMPLE ROUTINE, SIMPLY CLEARS TIMER A INTERRUPT
* CALL BY JSR SAMSTOP

SAMSTOP:
	MOVE.W SR,D7		; SAVE STATUS
	MOVE.W #$2700,SR	; KILL INTERRUPTS
	BCLR #5,$FFFA07		; TIMER A INTERRUPT OFF
	BCLR #5,$FFFA0B		; TIMER A PENDING CLEAR
	BCLR #5,$FFFA0F		; TIMER A INTERRUPT IN SERVICE CLR
	BCLR #5,$FFFA13		; TIMER A MASK OFF
	MOVE.W D7,SR		; STATUS BACK
	RTS			; RETURN

* SAMREC RECORDS A SAMPLE INTO MEMORY
* A0.L    = START ADDRESS
* A1.L    = LENGTH
* SPEED.W = SAMPLE SPEED


SAMREC:
	
	MOVE.L A0,STARTADDR		; START ADDRESS
	MOVE.L A1,LENGTH		; LENGTH
	MOVE.L A0,STARTADDR2		; BACKUP
	MOVE.L A1,LENGTH2		; BACKUP
	MOVE.W SR,D7			; STATUS SAVE
	MOVE.W #$2700,SR		; INTERRUPTS OFF
	CLR.B $FFFA19			; TIMER A OFF
	MOVE.B #1,$FFFA19		; TIMER A START
 	MOVE.B SPEED,d3			; SPEED
	ADD.B #19,d3			; ADD 19 TICKS
	move.b d3,$FFFA1F		; TIMER A DATA
	OR.B #$20,$FFFA13		; INTERRUPT MASK 
	OR.B #$20,$FFFA07		; INTERRUPT ENABLE
	BCLR.B #3,$FFFA17		; VECTOR REG
	MOVE.L #RECIRQ,$134		; ADDRESS OF ROUTINE
	MOVE.W D7,SR			; STATUS BACK
	RTS

* RECORD INTERRUPT ROUTINE *

RECIRQ:
	MOVEM.L D7/A3,-(SP)		; SAVE REGS ON STACK
	MOVEA.L STARTADDR,A3		; START ADDRESS
	clr.w d7			; CLR WORD
	MOVE.B $FB0001,D7		; GET INPUT DATA
	MOVE.B D7,(A3)			; SAVE IT IN MEMORY
	SUBQ.L #1,LENGTH		; LENGTH -1
	BEQ.S ROUTOFIT			; END, EXIT
	ADDQ.L #1,STARTADDR		; START ADDRESS +1
	LEA VOLDAT2(pc),A3		; VOLUME CONVERT TABLE
	LSL.W #4,D7			; D7 * 16
	MOVE.L 0(A3,D7.W),PSG		; DATA FOR VOLUME 1
	MOVE.L 4(A3,D7.W),PSG		; DATA FOR VOLUME 2
	MOVE.L 8(A3,D7.W),PSG		; DATA FOR VOLUME 3
	MOVEM.L (SP)+,D7/A3		; STACK STUFF BACK
	RTE				; RETURN FROM EXCEPTION
ROUTOFIT:
	ADDQ.L #1,STARTADDR		; START ADRESS +1
	BCLR #5,$FFFA07			; CLEAR TIMER A INTERRUPT
	MOVEM.L (SP)+,D7/A3		; STACK STUFF BACK
	RTE				; RET EXCEPTION

* THRU MODE ROUTINE

SAMTHRU:
	MOVE.W SR,D7			; SAVE STATUS
	MOVE.W #$2700,SR		; INTERRUPTS OFF
	CLR.B $FFFA19			; STOP TIMER A
	MOVE.B #1,$FFFA19		; START TIMER A
 	MOVE.B SPEED,d3			; SPEED
	ADD.B #19,d3			; +19
	move.b d3,$FFFA1F		; TIMER A DATA
	OR.B #$20,$FFFA13		
	OR.B #$20,$FFFA07		; ENABLE TIMER A
	BCLR.B #3,$FFFA17
	MOVE.L #THRUIRQ,$134		; ADDRESS OF ROUTINE
	MOVE.W D7,SR			; STATUS BACK
	RTS

THRUIRQ:
	MOVEM.L D7/A3,-(SP)
	MOVE.B $FB0001,D7
	ANDI.W #$FF,D7
	LEA VOLDAT2,A3
	LSL.W #4,D7
	MOVE.L 0(A3,D7.W),PSG
	MOVE.L 4(A3,D7.W),PSG
	MOVE.L 8(A3,D7.W),PSG
	MOVEM.L (SP)+,D7/A3
	RTE
	
AUTO_ON:	DC.W 0
STARTADDR:	DC.L 0
LENGTH:		DC.L 0
STARTADDR2:	DC.L 0
LENGTH2:	DC.L 0
TYPE:		DC.W 1
SPEED:		DC.B 41,0

	

* Conversion table as used in stos maestro

VOLDAT2:
	DC.L $08000000,$09000000,$0A000000,0
	DC.L $08000000,$09000000,$0A000100,0
	DC.L $08000100,$09000100,$0A000000,0
	DC.L $08000100,$09000100,$0A000100,0
	DC.L $08000200,$09000200,$0A000000,0
	DC.L $08000200,$09000200,$0A000100,0
	DC.L $08000300,$09000100,$0A000000,0
	DC.L $08000300,$09000100,$0A000100,0
	DC.L $08000400,$09000000,$0A000000,0
	DC.L $08000400,$09000100,$0A000100,0
	DC.L $08000400,$09000200,$0A000000,0
	DC.L $08000400,$09000200,$0A000100,0
	DC.L $08000500,$09000000,$0A000000,0
	DC.L $08000500,$09000100,$0A000100,0
	DC.L $08000500,$09000200,$0A000000,0
	DC.L $08000500,$09000200,$0A000100,0
	DC.L $08000500,$09000300,$0A000000,0
	DC.L $08000500,$09000300,$0A000100,0
	DC.L $08000600,$09000200,$0A000000,0
	DC.L $08000600,$09000200,$0A000100,0
	DC.L $08000600,$09000300,$0A000000,0
	DC.L $08000600,$09000300,$0A000000,0
	DC.L $08000600,$09000300,$0A000100,0
	DC.L $08000600,$09000300,$0A000100,0
	DC.L $08000600,$09000300,$0A000100,0
	DC.L $08000600,$09000300,$0A000200,0
	DC.L $08000600,$09000300,$0A000200,0
	DC.L $08000600,$09000300,$0A000200,0
	DC.L $08000700,$09000000,$0A000000,0
	DC.L $08000700,$09000100,$0A000100,0
	DC.L $08000700,$09000200,$0A000100,0
	DC.L $08000700,$09000200,$0A000200,0
	DC.L $08000700,$09000400,$0A000000,0
	DC.L $08000700,$09000400,$0A000100,0
	DC.L $08000700,$09000400,$0A000200,0
	DC.L $08000700,$09000400,$0A000300,0
	DC.L $08000800,$09000300,$0A000000,0
	DC.L $08000800,$09000300,$0A000200,0
	DC.L $08000800,$09000400,$0A000000,0
	DC.L $08000800,$09000400,$0A000200,0
	DC.L $08000800,$09000500,$0A000000,0
	DC.L $08000800,$09000500,$0A000100,0
	DC.L $08000800,$09000500,$0A000200,0
	DC.L $08000800,$09000500,$0A000300,0
	DC.L $08000900,$09000000,$0A000100,0
	DC.L $08000900,$09000000,$0A000100,0
	DC.L $08000900,$09000200,$0A000200,0
	DC.L $08000900,$09000200,$0A000200,0
	DC.L $08000A00,$09000300,$0A000000,0
	DC.L $08000A00,$09000300,$0A000100,0
	DC.L $08000A00,$09000300,$0A000200,0
	DC.L $08000A00,$09000300,$0A000200,0
	DC.L $08000A00,$09000400,$0A000100,0
	DC.L $08000A00,$09000400,$0A000100,0
	DC.L $08000A00,$09000400,$0A000200,0
	DC.L $08000A00,$09000400,$0A000200,0
	DC.L $08000A00,$09000400,$0A000200,0
	DC.L $08000A00,$09000400,$0A000300,0
	DC.L $08000A00,$09000400,$0A000300,0
	DC.L $08000A00,$09000400,$0A000400,0
	DC.L $08000A00,$09000400,$0A000400,0
	DC.L $08000A00,$09000400,$0A000400,0
	DC.L $08000A00,$09000400,$0A000500,0
	DC.L $08000A00,$09000400,$0A000500,0
	DC.L $08000A00,$09000400,$0A000500,0
	DC.L $08000A00,$09000500,$0A000000,0
	DC.L $08000A00,$09000500,$0A000200,0
	DC.L $08000A00,$09000500,$0A000300,0
	DC.L $08000A00,$09000500,$0A000400,0
	DC.L $08000A00,$09000600,$0A000000,0
	DC.L $08000A00,$09000600,$0A000200,0
	DC.L $08000A00,$09000600,$0A000300,0
	DC.L $08000A00,$09000600,$0A000400,0
	DC.L $08000A00,$09000600,$0A000500,0
	DC.L $08000A00,$09000700,$0A000000,0
	DC.L $08000A00,$09000700,$0A000000,0
	DC.L $08000A00,$09000700,$0A000100,0
	DC.L $08000A00,$09000700,$0A000200,0
	DC.L $08000A00,$09000700,$0A000200,0
	DC.L $08000A00,$09000700,$0A000300,0
	DC.L $08000A00,$09000700,$0A000400,0
	DC.L $08000B00,$09000000,$0A000000,0
	DC.L $08000B00,$09000100,$0A000000,0
	DC.L $08000B00,$09000100,$0A000100,0
	DC.L $08000B00,$09000200,$0A000000,0
	DC.L $08000B00,$09000200,$0A000100,0
	DC.L $08000B00,$09000300,$0A000000,0
	DC.L $08000B00,$09000300,$0A000200,0
	DC.L $08000B00,$09000400,$0A000000,0
	DC.L $08000B00,$09000400,$0A000200,0
	DC.L $08000B00,$09000400,$0A000300,0
	DC.L $08000B00,$09000400,$0A000400,0
	DC.L $08000B00,$09000600,$0A000000,0
	DC.L $08000B00,$09000600,$0A000200,0
	DC.L $08000B00,$09000600,$0A000300,0
	DC.L $08000B00,$09000600,$0A000400,0
	DC.L $08000B00,$09000800,$0A000000,0
	DC.L $08000B00,$09000800,$0A000100,0
	DC.L $08000B00,$09000800,$0A000300,0
	DC.L $08000B00,$09000800,$0A000400,0
	DC.L $08000B00,$09000900,$0A000000,0
	DC.L $08000B00,$09000900,$0A000200,0
	DC.L $08000B00,$09000900,$0A000300,0
	DC.L $08000B00,$09000900,$0A000400,0
	DC.L $08000C00,$09000400,$0A000000,0
	DC.L $08000C00,$09000400,$0A000000,0
	DC.L $08000C00,$09000400,$0A000100,0
	DC.L $08000C00,$09000400,$0A000100,0
	DC.L $08000C00,$09000500,$0A000200,0
	DC.L $08000C00,$09000500,$0A000200,0
	DC.L $08000C00,$09000500,$0A000300,0
	DC.L $08000C00,$09000500,$0A000300,0
	DC.L $08000C00,$09000500,$0A000400,0
	DC.L $08000C00,$09000500,$0A000400,0
	DC.L $08000C00,$09000600,$0A000000,0
	DC.L $08000C00,$09000600,$0A000100,0
	DC.L $08000C00,$09000600,$0A000200,0
	DC.L $08000C00,$09000600,$0A000400,0
	DC.L $08000C00,$09000700,$0A000000,0
	DC.L $08000C00,$09000700,$0A000200,0
	DC.L $08000C00,$09000700,$0A000400,0
	DC.L $08000C00,$09000800,$0A000000,0
	DC.L $08000C00,$09000800,$0A000200,0
	DC.L $08000C00,$09000800,$0A000300,0
	DC.L $08000C00,$09000800,$0A000400,0
	DC.L $08000C00,$09000900,$0A000000,0
	DC.L $08000C00,$09000900,$0A000200,0
	DC.L $08000C00,$09000900,$0A000300,0

	DC.L $08000D00,$09000000,$0A000000,0
	DC.L $08000D00,$09000100,$0A000000,0
	DC.L $08000D00,$09000100,$0A000100,0
	DC.L $08000D00,$09000200,$0A000100,0
	DC.L $08000D00,$09000300,$0A000100,0
	DC.L $08000D00,$09000300,$0A000200,0
	DC.L $08000D00,$09000400,$0A000000,0
	DC.L $08000D00,$09000400,$0A000200,0
	DC.L $08000D00,$09000400,$0A000300,0
	DC.L $08000D00,$09000400,$0A000400,0
	DC.L $08000D00,$09000500,$0A000300,0
	DC.L $08000D00,$09000500,$0A000400,0
	DC.L $08000D00,$09000600,$0A000300,0
	DC.L $08000D00,$09000600,$0A000400,0
	DC.L $08000D00,$09000700,$0A000000,0
	DC.L $08000D00,$09000700,$0A000200,0
	DC.L $08000D00,$09000700,$0A000300,0
	DC.L $08000D00,$09000700,$0A000400,0
	DC.L $08000D00,$09000700,$0A000500,0
	DC.L $08000D00,$09000700,$0A000500,0
	DC.L $08000D00,$09000800,$0A000000,0
	DC.L $08000D00,$09000800,$0A000200,0
	DC.L $08000D00,$09000800,$0A000400,0
	DC.L $08000D00,$09000800,$0A000500,0
	DC.L $08000D00,$09000900,$0A000100,0
	DC.L $08000D00,$09000900,$0A000300,0
	DC.L $08000D00,$09000900,$0A000400,0
	DC.L $08000D00,$09000900,$0A000500,0
	DC.L $08000D00,$09000900,$0A000500,0
	DC.L $08000D00,$09000900,$0A000600,0
	DC.L $08000D00,$09000900,$0A000600,0
	DC.L $08000D00,$09000900,$0A000600,0
	DC.L $08000D00,$09000A00,$0A000100,0
	DC.L $08000D00,$09000A00,$0A000200,0
	DC.L $08000D00,$09000A00,$0A000300,0
	DC.L $08000D00,$09000A00,$0A000300,0
	DC.L $08000D00,$09000A00,$0A000400,0
	DC.L $08000D00,$09000A00,$0A000500,0
	DC.L $08000D00,$09000A00,$0A000500,0
	DC.L $08000D00,$09000A00,$0A000600,0
	DC.L $08000D00,$09000B00,$0A000000,0
	DC.L $08000D00,$09000B00,$0A000100,0
	DC.L $08000D00,$09000B00,$0A000200,0
	DC.L $08000D00,$09000B00,$0A000300,0
	DC.L $08000D00,$09000B00,$0A000400,0
	DC.L $08000D00,$09000B00,$0A000400,0
	DC.L $08000D00,$09000B00,$0A000500,0
	DC.L $08000D00,$09000B00,$0A000500,0
	DC.L $08000E00,$09000000,$0A000000,0
	DC.L $08000E00,$09000000,$0A000100,0
	DC.L $08000E00,$09000300,$0A000000,0
	DC.L $08000E00,$09000400,$0A000300,0
	DC.L $08000E00,$09000400,$0A000500,0
	DC.L $08000E00,$09000500,$0A000400,0
	DC.L $08000E00,$09000500,$0A000500,0
	DC.L $08000E00,$09000700,$0A000000,0
	DC.L $08000E00,$09000700,$0A000300,0
	DC.L $08000E00,$09000700,$0A000400,0
	DC.L $08000E00,$09000700,$0A000400,0
	DC.L $08000E00,$09000800,$0A000200,0
	DC.L $08000E00,$09000800,$0A000400,0
	DC.L $08000E00,$09000800,$0A000500,0
	DC.L $08000E00,$09000800,$0A000500,0
	DC.L $08000E00,$09000900,$0A000000,0
	DC.L $08000E00,$09000900,$0A000100,0
	DC.L $08000E00,$09000900,$0A000200,0
	DC.L $08000E00,$09000900,$0A000300,0
	DC.L $08000E00,$09000900,$0A000500,0
	DC.L $08000E00,$09000900,$0A000500,0
	DC.L $08000E00,$09000900,$0A000600,0
	DC.L $08000E00,$09000900,$0A000700,0
	DC.L $08000E00,$09000A00,$0A000000,0
	DC.L $08000E00,$09000A00,$0A000500,0
	DC.L $08000E00,$09000A00,$0A000800,0
	DC.L $08000E00,$09000A00,$0A000900,0
	DC.L $08000E00,$09000B00,$0A000300,0
	DC.L $08000E00,$09000B00,$0A000600,0
	DC.L $08000E00,$09000B00,$0A000800,0
	DC.L $08000E00,$09000B00,$0A000900,0
	DC.L $08000E00,$09000C00,$0A000000,0
	DC.L $08000E00,$09000C00,$0A000100,0
	DC.L $08000E00,$09000C00,$0A000200,0
	DC.L $08000E00,$09000C00,$0A000300,0
	DC.L $08000E00,$09000C00,$0A000400,0
	DC.L $08000E00,$09000C00,$0A000400,0
	DC.L $08000E00,$09000C00,$0A000500,0
	DC.L $08000E00,$09000C00,$0A000500,0
	DC.L $08000E00,$09000C00,$0A000600,0
	DC.L $08000E00,$09000C00,$0A000600,0
	DC.L $08000E00,$09000C00,$0A000600,0
	DC.L $08000E00,$09000C00,$0A000600,0
	DC.L $08000E00,$09000C00,$0A000700,0
	DC.L $08000E00,$09000C00,$0A000700,0
	DC.L $08000E00,$09000C00,$0A000700,0
	DC.L $08000E00,$09000C00,$0A000700,0
	DC.L $08000E00,$09000D00,$0A000000,0
	DC.L $08000E00,$09000D00,$0A000100,0
	DC.L $08000E00,$09000D00,$0A000200,0
	DC.L $08000E00,$09000D00,$0A000200,0
	DC.L $08000E00,$09000D00,$0A000300,0
	DC.L $08000E00,$09000D00,$0A000400,0
	DC.L $08000E00,$09000D00,$0A000500,0
	DC.L $08000E00,$09000D00,$0A000500,0
	DC.L $08000E00,$09000D00,$0A000600,0
	DC.L $08000E00,$09000D00,$0A000600,0
	DC.L $08000E00,$09000D00,$0A000700,0
	DC.L $08000E00,$09000D00,$0A000700,0
	DC.L $08000E00,$09000D00,$0A000700,0
	DC.L $08000E00,$09000D00,$0A000700,0
	DC.L $08000E00,$09000D00,$0A000800,0
	DC.L $08000E00,$09000D00,$0A000800,0
	DC.L $08000E00,$09000E00,$0A000000,0
	DC.L $08000E00,$09000E00,$0A000000,0
	DC.L $08000E00,$09000E00,$0A000100,0
	DC.L $08000E00,$09000E00,$0A000100,0
	DC.L $08000E00,$09000E00,$0A000200,0
	DC.L $08000E00,$09000E00,$0A000200,0
	DC.L $08000E00,$09000E00,$0A000300,0
	DC.L $08000E00,$09000E00,$0A000300,0
	DC.L $08000E00,$09000E00,$0A000400,0
	DC.L $08000E00,$09000E00,$0A000500,0
	DC.L $08000E00,$09000E00,$0A000600,0
	DC.L $08000E00,$09000E00,$0A000600,0
	DC.L $08000E00,$09000E00,$0A000700,0
	DC.L $08000E00,$09000E00,$0A000700,0
	DC.L $08000E00,$09000E00,$0A000700,0
	DC.L $08000E00,$09000E00,$0A000700,0

hertz:	DC.B 0,0,0,0,0,91,75,63,54,47,41,36,32,28,25,22,20,18,16
	DC.B 14,13,11,10,9,8,7,6,5,4,3,2,1,0,0
	EVEN

snd_init:dc.b 0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,255,8,0,9,0,10,0,11,0,12,0,13,0,255,0

PSG =	 $FF8800

	END



